﻿DROP   TABLE IF EXISTS casting;
DROP   TABLE IF EXISTS acteur;
DROP   TABLE IF EXISTS film;
CREATE TABLE acteur (id_acteur,nom_acteur) AS (
VALUES (3,'Robert De Niro'),(4,'Sean Connery'),(6,'Harrison Ford'),(7,'Robin Williams'),(8,'Tom Hanks'),(9,'Arnold Schwarzenegger'),(12,'Al Pacino'),
       (13,'Bruce Willis'),(14,'Steve Martin'),(15,'Dan Aykroyd'),(17,'Nicolas Cage'),(19,'Tom Cruise'),(24,'Danny DeVito'),(25,'Tim Robbins'),
       (27,'Dustin Hoffman'),(32,'John Cusack'),(34,'John Travolta'),(35,'Jeff Bridges'),(39,'Anthony Hopkins'),(40,'Julia Roberts'),
       (43,'Jack Nicholson'),(44,'Robert Duvall'),(46,'Kevin Bacon'),(50,'Matthew Broderick'),(52,'Michael Keaton'),(53,'Keanu Reeves'),
       (54,'Sigourney Weaver'),(56,'Val Kilmer'),(57,'Meg Ryan'),(58,'Charlie Sheen'),(59,'Terry Gilliam'),(61,'Kevin Kline'),(63,'Meryl Streep'),
       (64,'Demi Moore'),(68,'Alan Parker'),(70,'Michael J. Fox'),(72,'Bill Murray'),(73,'Harvey Keitel'),(75,'Cary Grant'),(76,'Kevin Spacey'),
       (84,'Sandra Bullock'),(85,'Marlon Brando'),(89,'Samuel L. Jackson'),(91,'Morgan Freeman'),(92,'Sydney Pollack'),(94,'Diane Keaton'),
       (98,'Gary Oldman'),(99,'Christopher Walken'),(100,'Liam Neeson'),(114,'Alec Baldwin'),(120,'Steve Guttenberg'),(176,'Fred Ward'),(180,'John Candy'),
       (202,'Oliver Platt'),(217,'J.T. Walsh'),(223,'Matt Dillon'),(224,'Kiefer Sutherland'),(226,'William H. Macy'),(258,'Brad Pitt'),(278,'Elisabeth Shue'),
       (314,'John Lithgow'),(319,'Mickey Rourke'),(328,'Neve Campbell'),(330,'Dennis Dugan'),(331,'Laurence Fishburne'),(333,'Minnie Driver'),
       (341,'Michael McKean'),(349,'Ellen Barkin'),(352,'Christopher Guest'),(357,'Bruno Kirby'),(367,'Diane Lane'),(446,'Sarah Jessica Parker'),
       (458,'Kevin Dunn (I)'),(459,'John C. Reilly'),(480,'Jennifer Aniston'),(482,'R. Lee Ermey'),(504,'Dianne Wiest'),(516,'Xander Berkeley'),
       (520,'Stephen Tobolowsky'),(523,'Jay Mohr'),(528,'Kevin Pollak'),(567,'Olympia Dukakis'),(596,'Josh Brolin'),
       (613,'William Baldwin'),(637,'Illeana Douglas'),(717,'Luke Wilson'),(744,'David Strathairn'),(769,'John Ashton (I)'));
ALTER  TABLE acteur ADD CONSTRAINT pk_acteur PRIMARY KEY (id_acteur);
CREATE TABLE film (id_film,titre,annee) AS (
VALUES (1,'Star Wars : Episode IV - Un nouvel espoir','1977'),(2,'Les Évadés','1994'),(3,'Pulp Fiction','1994'),(5,'Star Wars: Episode V - L''empire contre-attaque','1980'),
       (6,'Usual Suspects','1995'),(7,'La liste de Schindler','1993'),(8,'Il faut sauver le soldat Ryan','1998'),(10,'American Beauty','1999'),
       (11,'Les Aventuriers de l''arche perdue','1981'),(12,'Le Parrain','1972'),(13,'Star Wars: Episode VI - Le retour du Jedi','1983'),(14,'Blade Runner','1982'),
       (15,'Le silence des agneaux','1991'),(16,'Forrest Gump','1994'),(17,'Star Wars: Episode I - La menace fantôme','1999'),(18,'Le sixième sens','1999'),
       (20,'Terminator 2 : Le jugement dernier','1991'),(21,'Seven','1995'),(24,'Aliens, le retour','1986'),(26,'Retour vers le futur','1985'),
       (28,'Vol au dessus d''un nid de coucou','1975'),(29,'Will Hunting','1997'),(30,'Le cinquième élément','1997'),(31,'L''armée des 12 singes','1995'),
       (35,'Alien - Le 8ème passager','1979'),(37,'Indiana Jones et la dernière croisade','1989'),(38,'Le fugitif','1993'),(39,'Reservoir Dogs','1992'),
       (42,'Piège de cristal','1988'),(43,'Les affranchis','1990'),(45,'Apocalypse Now','1979'),(46,'Terminator I','1984'),(47,'Pour le pire et pour le meilleur','1997'),
       (48,'Le Cercle des poètes disparus','1989'),(49,'Monty Python, sacré Graal','1975'),(51,'Rock','1996'),(53,'Apollo 13','1995'),(57,'Toy Story','1995'),
       (58,'Armageddon','1998'),(60,'Rain Man','1988'),(61,'Le Parrain II','1974'),(62,'Volte/Face','1997'),(63,'Shining','1980'),(65,'Taxi Driver','1976'),
       (67,'Les Blues Brothers','1980'),(70,'Dans la peau de John Malkovich','1999'),(73,'La Ligne verte','1999'),(76,'La Folle Journée de Ferris Bueller','1986'),
       (78,'Un Jour sans fin','1993'),(79,'Mission Impossible','1996'),(80,'Heat','1995'),(83,'Top Gun','1986'),(84,'Speed','1994'),(86,'Batman','1989'),
       (88,'Eyes Wide Shut','1999'),(89,'Brazil','1985'),(90,'The Big Lebowski','1998'),(91,'True lies - Le caméléon','1994'),(94,'La Mort aux trousses','1959'),
       (96,'A la poursuite d''Octobre Rouge','1990'),(99,'Mission Impossible 2','2000'),(100,'Un poisson nommé Wanda','1988'),
       (1067,'Vendredi 13',1980),(1048,'Meurtre à Alcatraz',1995),(904,'Footloose',1984),(1367,'Diner',1982),(1176,'La Rivière sauvage',1994),
       (1431,'Trait pour trait ',1997),(1668,'La vie en plus',1988),(1680,'Mon chien Skip',2000),(253,'Sleepers',1996),(134,'Des hommes d''honneur',1992),
       (229,'Sexcrimes',1998),(533,'L''Homme sans ombre',2000),(466,'Un ticket pour deux',1987),(587,'Tremors',1990),(571,'Hypnose',1999),
       (525,'L''Expérience interdite',1990));
ALTER  TABLE film ADD CONSTRAINT pk_film PRIMARY KEY (id_film);
CREATE TABLE casting (id_film,id_acteur) AS (
VALUES (1,6),(2,25),(2,91),(3,13),(3,34),(3,73),(3,89),(3,99),(5,6),(6,76),(7,100),(8,8),(10,76),(11,6),(12,12),(12,44),(12,85),(12,94),(13,6),(14,6),(15,39),
             (16,8),(17,100),(18,13),(20,9),(21,91),(24,54),(26,70),(28,24),(28,43),(29,7),(30,13),(30,98),(31,13),(35,54),(37,4),(37,6),(38,6),(39,73),(42,13),(43,3),
             (45,6),(45,44),(45,85),(46,9),(47,43),(48,7),(49,59),(51,4),(51,17),(53,8),(53,46),(57,8),(58,13),(60,19),(60,27),(61,3),(61,12),(61,44),(61,94),(62,17),
             (62,34),(63,43),(65,3),(65,73),(67,15),(70,32),(73,8),(76,50),(76,58),(78,72),(79,19),(80,3),(80,12),(80,56),(83,19),(83,25),(83,56),(83,57),(84,53),(84,84),
             (86,43),(86,52),(88,19),(88,92),(89,3),(90,35),(91,9),(94,75),(96,4),(99,19),(100,61),(134,46),(229,46),(253,46),(466,46),(525,46),(533,46),(571,46),(587,46),
             (1067,46),(1048,46),(904,46),(1367,46),(1176,46),(1431,46),(1668,46),(1680,46),(134,19),(134,43),(134,64),(134,217),(134,224),(134,352),(134,516),(134,528),
             (229,72),(229,223),(229,328),(253,3),(253,27),(253,258),(253,333),(253,357),(466,14),(466,180),(466,341),(525,613),(525,40),(525,202),(525,224),(533,596),
             (533,278),(571,637),(571,458),(587,176),(1048,98),(1048,226),(1048,482),(1048,520),(904,314),(904,446),(904,504),(1367,120),(1367,319),
             (1367,349),(1176,63),(1176,459),(1176,744),(1431,637),(1431,458),(1431,480),(1431,523),(1431,567),(1668,114),(1668,330),(1668,769),(1680,367),(1680,717));
ALTER  TABLE casting ADD CONSTRAINT pk_casting PRIMARY KEY (id_film, id_acteur);
ALTER  TABLE casting ADD CONSTRAINT fk_acteur FOREIGN KEY (id_acteur) REFERENCES acteur (id_acteur);
ALTER  TABLE casting ADD CONSTRAINT fk_film FOREIGN KEY (id_film) REFERENCES film (id_film);
WITH   RECURSIVE meme_tournage (id_acteur_orig,nom_acteur_orig,id_acteur_dest,nom_acteur_dest,film) AS (
SELECT casting1.id_acteur,acteur1.nom_acteur,casting2.id_acteur,acteur2.nom_acteur,titre||'('||annee||')'
FROM   casting casting1 JOIN casting casting2 ON (casting1.id_film=casting2.id_film 
                                             AND casting1.id_acteur != casting2.id_acteur)
       JOIN acteur acteur1 ON (casting1.id_acteur=acteur1.id_acteur)
       JOIN acteur acteur2 ON (casting2.id_acteur=acteur2.id_acteur)
       JOIN film ON (casting1.id_film=film.id_film)),
       distance_acteur (id_acteur_dest,distance,chemin)  AS (
SELECT DISTINCT id_acteur_orig,0,CAST('' AS TEXT)
FROM   meme_tournage WHERE nom_acteur_orig='Kevin Bacon'
UNION  ALL
SELECT arrivee.id_acteur_dest,depart.distance + 1,
       depart.chemin||'['||arrivee.id_acteur_orig||']'||arrivee.nom_acteur_orig||'->'||film||'->'
FROM   meme_tournage AS arrivee 
       INNER JOIN distance_acteur AS depart 
                   ON depart.id_acteur_dest = arrivee.id_acteur_orig 
WHERE  depart.chemin NOT LIKE '%['||arrivee.id_acteur_dest||']%' AND distance <7), 
       plus_courte_distance (distance) AS (
SELECT MIN(distance) FROM   distance_acteur WHERE  id_acteur_dest = 85),
       liste_distance (distance,chemin) AS (
SELECT distance_acteur.distance, chemin||'[85]Marlon Brando'
FROM   distance_acteur JOIN plus_courte_distance ON distance_acteur.distance = plus_courte_distance.distance
WHERE  id_acteur_dest = 85)
SELECT CAST(distance AS TEXT) AS "Bacon number",chemin AS "Sociogramme"
FROM   liste_distance; 